<?php
/*
  When loaded this hook will remove all empty lines & lines surrounded with "**" at the
beginning of document. Example:
%%
  ** Copyright (c) 2010 by OurGroup, Inc. **
  ** Please see LICENSE file for legal information. **

  == Document title ==
  ...document body follows...
%%
*/

UWikiDocument::$setSourceHooks[] = 'StripCopyrightFromUWikiDocument';

function ConvertUWikiDocumentCharset(&$source, $doc) {
  // 50 reduces lags on docs with many lines; a copyright block won't last for more than 50 lines anyway.
  $lines = explode("\n", $source, 50);
  while ($lines and (($line = trim($lines[0])) === '' or
         (substr($line, 0, 2).substr($line, -2) === '****'))) {
    array_shift($lines);
  }
  $source = join("\n", $lines);
}
